package com.yiboshi.science.param.query;

import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 *  结题经费记录表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "结题经费记录表VO")
public class ComConclusionFundsQueryVO extends PaginationVO {
    /** 结题信息表id */
    @ApiModelProperty(value = "结题信息表id", position = 1)
    @Length(max=36, message = "结题信息表id不能大于36")
    private String conclusionId;
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 2)
    private Integer year;
    /** 项目 */
    @ApiModelProperty(value = "项目", position = 3)
    @Length(max=36, message = "项目不能大于200")
    private String name;
    /** 金额 */
    @ApiModelProperty(value = "金额", position = 4)
    private BigDecimal amount;
    /** 用途 */
    @ApiModelProperty(value = "用途", position = 8)
    @Length(max=36, message = "用途不能大于200")
    private String used;
    /** 类型 1拔款 2其它途径筹资 3支出项目 */
    @ApiModelProperty(value = "类型 1拔款 2其它途径筹资 3支出项目", position = 2)
    private Integer type;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
}