package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 请求异常日志表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "请求异常日志表DTO")
public class LogsRequestExceptionDTO extends BaseDTO {
    /** ip地址 */
    @ApiModelProperty(value = "ip地址", position = 1)
    private String ipAddress;
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 2)
    private String username;
    /** 请求次数 */
    @ApiModelProperty(value = "请求次数", position = 3)
    private Integer requestCount;
    /** 请求类型 1 IP 2 用户  */
    @ApiModelProperty(value = "请求类型 1 IP 2 用户 ", position = 4)
    private Integer requestType;
    @ApiModelProperty(value = "起始时间", position = 7)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    @ApiModelProperty(value = "截止时间", position = 8)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
}