package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 单位科研项目及资金管理制度表 dto
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "单位科研项目及资金管理制度表 dto")
public class ComProjectManagementRuleDTO extends BaseDTO {
    /** 对象Id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象Id（项目Id/任务书Id）", position = 1 )
    @Length(max=36, message = "对象Id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 单位政策名称 */
    @ApiModelProperty(value = "单位政策名称", position = 2 )
    @Length(max=100, message = "单位政策名称不能大于100")
    private String policyName;
    /** 出台日期 */
    @ApiModelProperty(value = "出台日期", position = 2 )
    private Date releaseDate;
    /** 文号 */
    @ApiModelProperty(value = "文号", position = 3 )
    @Length(max=100, message = "文号不能大于100")
    private String documentNumber;
    /** 有效期 */
    @ApiModelProperty(value = "有效期", position = 2 )
    private Date validityPeriod;
    /** 主要内容 */
    @ApiModelProperty(value = "主要内容", position = 4 )
    @Length(max=200, message = "在项目中的分工不能大于200")
    private String mainContent;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 4 )
    private String fileId;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1 )
    @Length(max=36, message = "附件Id不能大于36")
    private String downloadId;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 6)
    private String fileName;
    /** URL */
    @ApiModelProperty(value = "URL", position = 7)
    private String downloadUrl;
}