package com.yiboshi.science.param.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目二级学科统计DTO")
public class ComProjectKnowledgeStatisticDTO extends BaseDTO {

    /** 项目组Id */
    @ApiModelProperty(value = "项目组Id", position = 1)
    @Length(max=36, message = "项目组Id不能大于36")
    private String groupId;
    /** 二级学科Id */
    @ApiModelProperty(value = "二级学科Id", position = 1)
    @Length(max=36, message = "二级学科Id不能大于36")
    private String knowledgeId;
    /** 二级学科名称 */
    @ExcelProperty("二级学科名称")
    @ApiModelProperty(value = "二级学科名称", position = 2)
    private String knowledgeName;
    /** 排序号 */
    @ExcelProperty("排序号")
    @ApiModelProperty(value = "排序号", position = 3)
    private Integer displayOrder;
    /** 项目数 */
    @ExcelProperty("项目数")
    @ApiModelProperty(value = "项目数", position = 4)
    private Integer projCount;
}
