package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 附件目录表DTO
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "附件目录表DTO")
public class ComFileDTO extends BaseDTO {
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1)
    private String downloadId;
    /** 对象Id(项目Id/任务书Id) */
    @ApiModelProperty(value = "对象Id(项目Id/任务书Id)", position = 2)
    private String objectId;
    /** 附件说明 */
    @ApiModelProperty(value = "附件说明", position = 3)
    private String fileExplain;
    /** 文件类型 */
    @ApiModelProperty(value = "文件类型", position = 4)
    private Integer fileType;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 5)
    private Integer showIndex;

    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 6)
    private String fileName;
    /** URL */
    @ApiModelProperty(value = "URL", position = 7)
    private String downloadUrl;
    /** 必要附件(必须显示不能删除) */
    @ApiModelProperty(value = "必要附件", position = 8)
    private Boolean required;
    /** 必须上传的附件 */
    @ApiModelProperty(value = "必须上传的附件", position = 8)
    private Boolean isRequired;
    /** 是否为标题 */
    @ApiModelProperty(value = "是否为标题", position = 8)
    private Boolean isTitle;
}