package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家项目分配表DTO")
public class ComExpertSpecDTO extends BaseDTO {
    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 2)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;
    /** 专业Id */
    @ApiModelProperty(value = "专业Id", position = 3)
    @Length(max=36, message = "专业Id不能大于36")
    private String specId;

    /** 专业名称 */
    @ApiModelProperty(value = "专业名称", position = 4)
    @Length(max=200, message = "专业名称不能大于200")
    private String specName;

    /** 排序 */
    @ApiModelProperty(value = "排序", position = 5)
    private Integer showIndex;
}
