package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家组分配表DTO")
public class ComExpertGroupAssignDTO extends BaseDTO {
    /** 专家组Id */
    @ApiModelProperty(value = "专家组Id", position = 2)
    @Length(max=36, message = "专家组Id不能大于36")
    private String groupId;
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 3)
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 分配年度 */
    @ApiModelProperty(value = "分配年度", position = 4)
    private Integer assignYear;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 5)
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    /** 分配项目数 */
    @ApiModelProperty(value = "分配项目数", position = 6)
    private Integer assignCount ;
}
