package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 预期成果VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "预期成果VO")
public class ComProjectResults extends BaseEntity {

    /** 对象Id（中期考核表Id） */
    @ApiModelProperty(value = "对象Id（中期考核表Id）", position = 1 )
    @Length(max=36, message = "对象Id（中期考核表Id）不能大于36")
    private String objectId;
    /** 成果Id (参数表获取) */
    @ApiModelProperty(value = "成果Id (参数表获取)", position = 2 )
    @Length(max=36, message = "成果Id (参数表获取)不能大于36")
    private String resultId;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 3 )
    private Integer resultCount;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 4 )
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;

}