package com.yiboshi.science.entity;


import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目分组明细表VO")
public class ComProjectGroupDetail extends BaseEntity {

    /** 项目组Id */
    @ApiModelProperty(value = "项目组Id", position = 1)
    @Length(max=36, message = "项目组Id不能大于36")
    private String groupId;

    /** 二级学科Id */
    @ApiModelProperty(value = "二级学科Id", position = 1)
    @Length(max=36, message = "二级学科Id不能大于36")
    private String knowledgeId;

    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 2)
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 3)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;
}
