package com.yiboshi.science.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 人员表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "人员表VO")
public class ComPerson extends BaseEntity {
    /** 人员id */
    @ApiModelProperty(value = "人员id", position = 1)
    private Long longId;
    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 1 , required = true)
    @NotNull(message = "证件号不能为空")
    @Length(max=100, message = "证件号不能大于100")
    private String certId;
    /** 证件类型 (参数表获取) */
    @ApiModelProperty(value = "证件类型 (参数表获取)", position = 2 )
    @Length(max=36, message = "证件类型 (参数表获取)不能大于36")
    private String certType;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 3 )
    @Length(max=60, message = "姓名不能大于60")
    private String personName;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 4 )
    @Length(max=2, message = "性别不能大于2")
    private String sex;
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 5 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 单位Id */
    @ApiModelProperty(value = "单位Id", position = 6 )
    @Length(max=36, message = "单位Id不能大于36")
    private String unitId;
    /** 人员状态 1 正常 2 注销 */
    @ApiModelProperty(value = "人员状态 1 正常 2 注销", position = 7 )
    private Integer personState;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 8 )
    @Length(max=36, message = "学位不能大于36")
    private String degree;
    /** 最高学位授予时间 */
    @ApiModelProperty(value = "最高学位授予时间", position = 5)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date degreeTime;
    /** 最高学位授予单位 */
    @ApiModelProperty(value = "最高学位授予单位", position = 9)
    @Length(max=200, message = "最高学位授予单位")
    private String degreeUnit;
    /** 是否为研究生导师 */
    @ApiModelProperty(value = "是否为研究生导师", position = 8)
    @Length(max=120, message = "是否为研究生导师不能大于120")
    private String graduateTeacher;
    /** 党派 */
    @ApiModelProperty(value = "党派", position = 9)
    @Length(max=30, message = "党派")
    private String politicalParty;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 8)
    @Length(max=36, message = "学历不能大于36")
    private String education;
    /** 民族 */
    @ApiModelProperty(value = "民族", position = 8 )
    @Length(max=36, message = "民族不能大于36")
    private String nation;
    /** 职务 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=100, message = "职务不能大于100")
    private String duty;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 10 )
    @Length(max=36, message = "职称不能大于36")
    private String title;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 11 )
    @Length(max=36, message = "专业不能大于36")
    private String spec;
    /** 现从事专业 */
    @ApiModelProperty(value = "现从事专业", position = 11 )
    @Length(max=36, message = "现从事专业不能大于36")
    private String profession;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 12 )
    @Length(max=100, message = "邮箱不能大于100")
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 13 )
    @Length(max=100, message = "电话号码不能大于100")
    private String mobile;
    /** 电话 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String telephone;
    /** 传真 */
    @ApiModelProperty(value = "职务", position = 9 )
    @Length(max=36, message = "职务不能大于36")
    private String fax;
    /** 照片 */
    @ApiModelProperty(value = "照片", position = 14 )
    @Length(max=36, message = "照片不能大于36")
    private String photo;
    /** 住址 */
    @ApiModelProperty(value = "住址", position = 15 )
    @Length(max=200, message = "住址不能大于200")
    private String address;
    /** 开户银行 */
    @ApiModelProperty(value = "开户银行", position = 17)
    @Length(max=200, message = "开户银行不能大于100")
    private String openBank;
    /** 开户账号 */
    @ApiModelProperty(value = "开户账号", position = 18)
    @Length(max=200, message = "开户账号不能大于30")
    private String openAcount;

    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 19)
    @Length(max=200, message = "工作单位")
    private String workUnit;
    /** 主管部门 */
    @ApiModelProperty(value = "主管部门", position = 19)
    @Length(max=50, message = "主管部门")
    private String managerDept;
    /** 单位电话 */
    @ApiModelProperty(value = "单位电话", position = 19)
    @Length(max=20, message = "单位电话")
    private String teleUnit;
    /** 单位邮政编码 */
    @ApiModelProperty(value = "单位邮政编码", position = 19)
    @Length(max=10, message = "单位邮政编码")
    private String postalCode;
    /** 单位通讯地址 */
    @ApiModelProperty(value = "单位通讯地址", position = 19)
    @Length(max=10, message = "单位通讯地址")
    private String addressUnit;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 19 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;
    /** 主要研究领域 */
    @ApiModelProperty(value = "主要研究领域", position = 19 )
    @Length(max=200, message = "主要研究领域不能大于200")
    private String mainResearchAreas;

    /** 1 待审核，10 审核通过， 20 审核不通过 ，30 返回修改 */
    @ApiModelProperty(value = "审核结果", position = 25)
    private Integer auditResult;
    /** 审核内容 */
    @ApiModelProperty(value = "审核内容", position = 24 )
    private String auditContent;
    /** 审核单位*/
    @ApiModelProperty(value = "审核单位", position = 28 )
    private String auditUnit;
    /** 审核人 */
    @ApiModelProperty(value = "审核人", position = 27)
    private String auditPerson;
    /** 审核时间 */
    @ApiModelProperty(value = "审核时间", position = 26 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date auditDate;
}