package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.arch.exception.BusinessException;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.SystemSetDAO;
import com.yiboshi.science.entity.SystemSet;
import com.yiboshi.science.param.dto.SystemSetDTO;
import com.yiboshi.science.param.query.SystemSetQueryVO;
import com.yiboshi.science.service.SystemSetService;
import com.yiboshi.science.utils.RedisKey;
import com.yiboshi.science.utils.RedisUtils;
import com.yiboshi.science.utils.SystemSetKey;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 配置表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
@AllArgsConstructor
public class SystemSetServiceImpl extends BaseServiceImpl<SystemSetDAO, SystemSetQueryVO, SystemSetDTO, SystemSet> implements SystemSetService {

    private RedisUtils redisUtils;

    @Override
    protected void setCriteriaForQuery(SystemSetQueryVO vo, QueryWrapper<SystemSetQueryVO> criteria) {
        if (Objects.nonNull(vo.getName())) {
            criteria.eq("name", vo.getName());
        }
        if (Objects.nonNull(vo.getValue())) {
            criteria.eq("value", vo.getValue());
        }
        if (Objects.nonNull(vo.getDescription())) {
            criteria.eq("description", vo.getDescription());
        }
    }

    /**
     * 根据Key 获取设置信息
     *
     * @param Key
     * @return
     */
    @Override
    public String getByKey(String Key) {
        List<SystemSet> list = getList();
        if (null == list)
            return null;
        list = list.stream().filter(e -> e.getName().equals(Key)).collect(Collectors.toList());
        if (null != list && list.size() > 0)
            return list.stream().findFirst().get().getValue();
        else{
            return getValueByKey(Key);
        }
    }

    @Transactional
    public String save(Map<String, Object> map) {
        String SMSApiUrl = "";
        String loginType = "";
        String systemType = "";
        if (!map.containsKey("SMSApiUrl"))
            throw new BusinessException("参数错误");
        if (!map.containsKey("loginType"))
            throw new BusinessException("参数错误");
        if (!map.containsKey("systemType"))
            throw new BusinessException("参数错误");
        SMSApiUrl = (String) map.get("SMSApiUrl");
        loginType = (String) map.get("loginType");
        systemType = (String) map.get("systemType");
        if (Objects.nonNull(SMSApiUrl)) {
            SystemSet set=getBykey(SystemSetKey.SMSApiUrl);
            if(null!=set){
                set.setValue(SMSApiUrl);
                this.update(set);
            }
            else{
                set=new SystemSet();
                set.setName(SystemSetKey.SMSApiUrl);
                set.setValue(SMSApiUrl);
                this.insert(set);
            }
        }
        if (Objects.nonNull(loginType)) {
            SystemSet set=getBykey(SystemSetKey.LoginType);
            if(null!=set){
                set.setValue(loginType);
                this.update(set);
            }
            else{
                set=new SystemSet();
                set.setName(SystemSetKey.LoginType);
                set.setValue(loginType);
                this.insert(set);
            }
        }
        if (Objects.nonNull(systemType)) {
            SystemSet set=getBykey(SystemSetKey.SysProjectType);
            if(null!=set){
                set.setValue(systemType);
                this.update(set);
            }
            else{
                set=new SystemSet();
                set.setName(SystemSetKey.SysProjectType);
                set.setValue(systemType);
                this.insert(set);
            }
        }
        redisUtils.del(RedisKey.SystemSetList);
        return "ok";
    }

    private SystemSet getBykey(String key) {
        SystemSet set = new SystemSet();
        set.setName(key);
        set = this.getEntity(set);
        if (null != set)
            return set;
        return null;
    }

    private String getValueByKey(String key) {
        SystemSet set = new SystemSet();
        set.setName(key);
        set = this.getEntity(set);
        if (null != set)
            return set.getValue();
        return null;
    }

    /**
     * 获取系统设置列表
     *
     * @return
     */
    public List<SystemSet> getList() {
        List<SystemSet> list;
        Object obj = redisUtils.get(RedisKey.SystemSetList);
        if (null != obj)
            list = (List<SystemSet>) redisUtils.get(RedisKey.SystemSetList);
        else {
            list = this.entityList(new SystemSet());
            redisUtils.set(RedisKey.SystemSetList, list, 7, TimeUnit.DAYS);
        }
        return list;
    }
}
