package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectStageGoalDAO;
import com.yiboshi.science.entity.ComProjectStageGoal;
import com.yiboshi.science.param.dto.ComProjectStageGoalDTO;
import com.yiboshi.science.param.query.ComProjectStageGoalQueryVO;
import com.yiboshi.science.service.ComProjectStageGoalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 任务书主要研发内容 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectStageGoalServiceImpl extends BaseServiceImpl<ComProjectStageGoalDAO, ComProjectStageGoalQueryVO, ComProjectStageGoalDTO,ComProjectStageGoal> implements ComProjectStageGoalService {
    @Autowired
    private ComProjectStageGoalDAO comProjectStageGoalDAO;
    @Override
    protected void setCriteriaForQuery(ComProjectStageGoalQueryVO vo, QueryWrapper<ComProjectStageGoalQueryVO> criteria) {
        if(Objects.nonNull(vo.getObjectId())){
            criteria.eq("object_id", vo.getObjectId());
        }
        if(Objects.nonNull(vo.getContentInfo())){
            criteria.eq("content_info", vo.getContentInfo());
        }
        if(Objects.nonNull(vo.getStartTime())){
            criteria.eq("start_time", vo.getStartTime());
        }
        if(Objects.nonNull(vo.getEndTime())){
            criteria.eq("end_time", vo.getEndTime());
        }
        if(Objects.nonNull(vo.getShowIndex())){
            criteria.eq("show_index", vo.getShowIndex());
        }
    }
    public List<ComProjectStageGoalDTO> getListByObjectId(String objectId)
    {
        return comProjectStageGoalDAO.getListByObjectId(objectId);
    }

    public void deleteByObjectId(String objectId) {
        ComProjectStageGoal model = new ComProjectStageGoal();
        model.setObjectId(objectId);
        this.delete(model);
    }

    public void insertList(List<ComProjectStageGoalDTO> list, String objectId) {
        ComProjectStageGoal model =new ComProjectStageGoal();
        model.setObjectId(objectId);
        this.delete(model);
        if (null != list) {
            List<ComProjectStageGoal> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComProjectStageGoal item = convert2Entity(list.get(i));
                item.setObjectId(objectId);
                item.setShowIndex(i+1);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }
}
