package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectKpitDAO;
import com.yiboshi.science.entity.ComProjectKpit;
import com.yiboshi.science.param.dto.ComProjectKpitDTO;
import com.yiboshi.science.param.query.ComProjectKpitQueryVO;
import com.yiboshi.science.service.ComProjectKpitService;
import com.yiboshi.science.utils.RedisKey;
import com.yiboshi.science.utils.RedisUtils;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class ComProjectKpitServiceImpl extends BaseServiceImpl<ComProjectKpitDAO, ComProjectKpitQueryVO, ComProjectKpitDTO, ComProjectKpit> implements ComProjectKpitService {

    private final RedisUtils redisUtils;

    @Autowired
    private ComProjectKpitDAO comProjectKpitDAO;

    @Override
    protected void setCriteriaForQuery(ComProjectKpitQueryVO vo, QueryWrapper<ComProjectKpitQueryVO> criteria) {

    }

    public List<ComProjectKpitDTO> getProjectKpitStatistic() {
        //一级指标名称
        List<ComProjectKpitDTO> oneLevelList = getProjectKpitByTypeId(2);
        //二级指标名称
        List<ComProjectKpitDTO> towLevelList = getProjectKpitByTypeId(3);
        //三级指标名称
        List<ComProjectKpitDTO> threeLevelList = getProjectKpitByTypeId(4);

        threeLevelList.forEach(e -> {
            List<ComProjectKpitDTO> findList1 = towLevelList.stream().filter(f -> e.getLevelId().equals(f.getId())).collect(Collectors.toList());
            ComProjectKpitDTO towModel = findList1.get(0);
            e.setTowLevelName(towModel.getKpitName());

            List<ComProjectKpitDTO> findList2 = oneLevelList.stream().filter(f -> towModel.getLevelId().equals(f.getId())).collect(Collectors.toList());
            ComProjectKpitDTO oneModel = findList2.get(0);
            e.setOneLevelName(oneModel.getKpitName());
        });

        return threeLevelList;
    }

    public List<ComProjectKpitDTO> getProjectKpitByTypeId(int typeId) {
        List<ComProjectKpitDTO> list = this.getProjectKpit();

        List<ComProjectKpitDTO> findList = list.stream().filter(e -> e.getTypeId().equals(typeId)).collect(Collectors.toList());

        return findList;
    }
    //threeLevelList

    public List<ComProjectKpitDTO> getProjectKpit() {
        List<ComProjectKpitDTO> list = null;
        Object obj = redisUtils.get(RedisKey.ProjectKPIList + "all");
        if (null != obj)
            list = (List<ComProjectKpitDTO>) redisUtils.get(RedisKey.ProjectKPIList + "all");
        else {
            list = comProjectKpitDAO.getProjectKpit();
            redisUtils.set(RedisKey.ProjectKPIList + "all", list, 7, TimeUnit.DAYS);
        }
        return list;
    }
}
