package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComNoticeDAO;
import com.yiboshi.science.entity.ComNotice;
import com.yiboshi.science.param.dto.ComNoticeDTO;
import com.yiboshi.science.param.query.ComNoticeQueryVO;
import com.yiboshi.science.service.ComNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 通知公告表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComNoticeServiceImpl extends BaseServiceImpl<ComNoticeDAO, ComNoticeQueryVO, ComNoticeDTO, ComNotice> implements ComNoticeService {

    @Autowired
    private ComNoticeDAO comNoticeDAO;

    @Override
    protected void setCriteriaForQuery(ComNoticeQueryVO vo, QueryWrapper<ComNoticeQueryVO> criteria) {

    }

    @Override
    public Pagination<ComNoticeDTO> getListByPage(ComNoticeQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComNoticeQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComNoticeDTO> dtoList = comNoticeDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    public String save(ComNoticeDTO dto) {
        String id = "";
        ComNotice comNotice = convert2Entity(dto);
        if (Objects.isNull(dto.getId()))
            id = this.insert(comNotice);
        else
            id = this.update(comNotice);
        return id;
    }

    public ComNoticeDTO getLatestNotice() {
        QueryWrapper criteria = new QueryWrapper();
        this.setCriteriaForQuery(new ComNoticeQueryVO(), criteria);
        return comNoticeDAO.getLatestNotice(criteria);
    }
}
