package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.SystemParameterType;
import com.yiboshi.science.param.dto.SystemParameterTypeDTO;
import com.yiboshi.science.param.query.SystemParameterTypeQueryVO;

import java.util.List;

/**
 * 参数类型表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemParameterTypeService extends BaseService<SystemParameterTypeQueryVO, SystemParameterTypeDTO, SystemParameterType>{
    /**获取最大TypeId
     *
     * @return
     */
    Integer getMaxTypeId();
    /**
     * 删除
     *
     * @param id
     */
    String deleteParameterTypeById(String id);
    /**获取参数类型
     *
     * @return
     */
    List<SystemParameterType> getParameterTypeList();
    /**获取参数类型
     *
     * @return
     */
    SystemParameterType getParameterTypeByType(Integer typeId);
    /**保存参数类型
     *
     * @return
     */
    String save(SystemParameterTypeDTO dto);
    /**获取参数列表
     *
     * @return
     */
    List<SystemParameterType> getList();
}
