package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.entity.SystemSet;
import com.yiboshi.science.param.dto.SystemSetDTO;
import com.yiboshi.science.param.query.SystemSetQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.SystemParameterService;
import com.yiboshi.science.service.SystemSetService;
import com.yiboshi.science.utils.SystemSetKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 功能：配置表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "system-set",description = "配置表")
@RestController
@RequestMapping("/v1/science-admin/system-set")
public class SystemSetController extends BaseController<SystemSetService,SystemSetQueryVO, SystemSetDTO, SystemSet> {

    @Autowired
    private SystemSetService systemSetService;

    @Autowired
    private SystemParameterService systemParameterService;

    @ApiOperation(value = "获取系统配置", httpMethod = "GET", notes = "获取系统配置")
    @RequestMapping(value = "/getSystemSet")
    @GetMapping
    public ResponseDataModel<Map<String, Object>> getSystemSet() {
        Map<String, Object> data = new HashMap<String, Object>(5) {
            {
                put("SMSApiUrl", systemSetService.getByKey(SystemSetKey.SMSApiUrl));
                put("loginType", systemSetService.getByKey(SystemSetKey.LoginType));
                put("systemType", systemSetService.getByKey(SystemSetKey.SysProjectType));
            }
        };
        return ResponseDataModel.ok(data);
    }

    @ApiOperation(value = "1.02", httpMethod = "POST", notes = "项目分配")
    @RequestMapping("/save")
    @PostMapping
    public ResponseDataModel<String> save(@RequestBody Map<String, Object> map) {
        return ResponseDataModel.ok(systemSetService.save(map));
    }

    @ApiOperation(value = "获取系统配置", httpMethod = "GET", notes = "获取系统配置")
    @RequestMapping(value = "/getTalentTraningInfo")
    @GetMapping
    public ResponseDataModel<Map<String, Object>> getTalentTraningInfo() {
        List<SystemParameter> parameterList = systemParameterService.getListByType(21);
        Map<String, Object> data = new HashMap<String, Object>(9) {
            {
                parameterList.forEach(e -> {
                    put(e.getCode(), e.getId());
                });
                put("ALTrainingYear", systemSetService.getByKey(SystemSetKey.SysALTrainingYear));
                put("ALEveryYearFee", systemSetService.getByKey(SystemSetKey.SysALEveryYearFee));
                put("HTTrainingYear", systemSetService.getByKey(SystemSetKey.SysHTTrainingYear));
                put("HTEveryYearFee", systemSetService.getByKey(SystemSetKey.SysHTEveryYearFee));
                put("RTTrainingYear", systemSetService.getByKey(SystemSetKey.SysRTTrainingYear));
                put("RTEveryYearFee", systemSetService.getByKey(SystemSetKey.SysRTEveryYearFee));
            }
        };
        return ResponseDataModel.ok(data);
    }
}
