package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.config.annotation.Logs;
import com.yiboshi.science.entity.ComDownload;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.ComDownloadDTO;
import com.yiboshi.science.param.query.ComDownloadQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComDownloadService;
import com.yiboshi.science.service.SystemSetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;


/**
 * 功能：附件表 接口
 *
 * @author lkl
 * @version 2021-08-25
 */
@Api(tags = "com-download", description = "附件表")
@RestController
@RequestMapping("/v1/science-admin/com-download")
@RequiredArgsConstructor
public class ComDownloadController extends BaseController<ComDownloadService, ComDownloadQueryVO, ComDownloadDTO, ComDownload> {

    @Autowired
    private ComDownloadService ComDownloadService;

    @Autowired
    private SystemSetService systemSetService;

    @ApiOperation(value = "文件上传", httpMethod = "POST", notes = "文件上传")
    @PostMapping("/asyncUpload")
//  @Logs(value = CommonEnum.logType.fileUpload)
    public ResponseDataModel<ComDownload> asyncUpload(@RequestParam("file") MultipartFile file) {
        return ResponseDataModel.ok(ComDownloadService.asyncUpload(file));
    }

    @ApiOperation(value = "文件上传", httpMethod = "POST", notes = "文件上传")
    @PostMapping("/asyncApplyBookUpload")
//  @Logs(value = CommonEnum.logType.fileUpload)
    public ResponseDataModel<ComDownload> asyncApplyBookUpload(@RequestParam("file") MultipartFile file) {
        return ResponseDataModel.ok(ComDownloadService.asyncApplyBookUpload(file));
    }


    @ApiOperation(value = "删除文件", httpMethod = "DELETE", notes = "删除文件")
    @DeleteMapping(value = "delete/{id}")
    @Logs(value = CommonEnum.logType.fileDelete)
    public ResponseDataModel<String> delete(@PathVariable String id) {
        return ResponseDataModel.ok("ok");
//      return ResponseDataModel.ok(ComDownloadService.delete(id));
    }

    @ApiOperation(value = "申报书文件列表", httpMethod = "GET", notes = "申报书文件列表")
    @GetMapping
    @RequestMapping("/getAllListByPage")
    @PreAuthorize("hasAnyRole('ADMIN')")
    public ResponseDataModel<Pagination<ComDownloadDTO>> getAllListByPage(@Validated ComDownloadQueryVO vo, BindingResult bindingResult) {
        Pagination<ComDownloadDTO> page = ComDownloadService.getAllListByPage(vo);

        return ResponseDataModel.ok(page);
    }
}
