package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 查询请求异常日志表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询请求异常日志表VO")
public class LogsRequestExceptionQueryVO extends PaginationVO{

    /** ip地址 */
    @ApiModelProperty(value = "ip地址", position = 1)
    private String ipAddress;
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 2)
    private String username;
    /** 请求次数 */
    @ApiModelProperty(value = "请求次数", position = 3)
    private Integer requestCount;
    /** 请求类型 1 IP 2 用户  */
    @ApiModelProperty(value = "请求类型 1 IP 2 用户 ", position = 4)
    private Integer requestType;

    /** 起始时间 */
    @ApiModelProperty(value = "起始时间", position = 10)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 截止时间 */
    @ApiModelProperty(value = "截止时间", position = 11)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
}