package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import com.yiboshi.science.entity.ComPersonScientificGain;
import com.yiboshi.science.param.dto.ComPersonResumeDTO;
import com.yiboshi.science.param.dto.ComTalentBudgetDTO;
import com.yiboshi.science.param.dto.ComTalentMembersDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 人才申请表查询VO
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "人才申请表查询VO")
public class ComTalentApplyQueryVO extends PaginationVO {

    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "人员ID")
    private String personId;

    /** 证件号 */
    @ApiModelProperty(value = "证件号")
    private String certId;

    /** 姓名 */
    @ApiModelProperty(value = "姓名")
    private String personName;

    /** 性别 */
    @ApiModelProperty(value = "性别", position = 5)
    private String sex;
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 6)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;

    /** 申报年度 */
    @ApiModelProperty(value = "申报年度")
    private Integer reportYear;

    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id")
    private String appUnitId;

    /** 申报人Id */
    @ApiModelProperty(value = "申报人Id")
    private String appPersonId;

    /** 人才类别 */
    @ApiModelProperty(value = "人才类别")
    private String talentCategory;

    @ApiModelProperty(value = "是否是省级或省级以上人才")
    private Integer isProvincialTalent;

    @ApiModelProperty(value = "人才类型")
    private String talentType;

    @ApiModelProperty(value = "荣誉称号")
    private String honoraryTitle;

    @ApiModelProperty(value = "任职情况1")
    private String holdPost1;

    @ApiModelProperty(value = "任职情况2")
    private String holdPost2;

    @ApiModelProperty(value = "任职情况3")
    private String holdPost3;

    @ApiModelProperty(value = "支持条件")
    private String supportingConditions;

    @ApiModelProperty(value = "研究类型")
    private String researchType;

    @ApiModelProperty(value = "研究开始时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date researchStart;

    @ApiModelProperty(value = "研究结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date researchEnd;

    @ApiModelProperty(value = "资助经费")
    private BigDecimal supportFund;

    @ApiModelProperty(value = "研究内容")
    private String researchContent;

    @ApiModelProperty(value = "技术特点")
    private String technicalSkill;

    @ApiModelProperty(value = "量化指标")
    private String qualityTarget;

    @ApiModelProperty(value = "研究条件")
    private String researchCondition;

    @ApiModelProperty(value = "研究进度")
    private String researchProgress;

    @ApiModelProperty(value = "计划目标")
    private String planTarget;

    @ApiModelProperty(value = "单位意见")
    private String unitAdvice;

    @ApiModelProperty(value = "申请经费")
    private BigDecimal applyFund;

    @ApiModelProperty(value = "其他经费")
    private BigDecimal otherFund;

    @ApiModelProperty(value = "总经费")
    private BigDecimal totalFund;

    /** 人才申报状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准,50 批准 */
    @ApiModelProperty(value = "人才申报状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准,50 批准", position = 7 )
    private Integer talentState;

    /** 项目完成状态 */
    @ApiModelProperty(value = "项目完成状态")
    private String completeStatus;

    @ApiModelProperty(value = "团队成员列表")
    private List<ComTalentMembersDTO> membersList;

    @ApiModelProperty(value = "预算列表")
    private List<ComTalentBudgetDTO> budgetList;

    @ApiModelProperty(value = "简历列表")
    private List<ComPersonResumeDTO> resumeList;

    @ApiModelProperty(value = "科研学术成绩")
    private List<ComPersonScientificGain> scientificList;
} 