package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 查询预期成果VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询预期成果VO")
public class ComProjectResultsQueryVO extends PaginationVO{
    /** 对象Id（中期考核表Id） */
    @ApiModelProperty(value = "对象Id（中期考核表Id）", position = 1)
    private String objectId;
    /** 成果Id (参数表获取) */
    @ApiModelProperty(value = "成果Id (参数表获取)", position = 2)
    private String resultId;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 3)
    private Integer resultCount;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 4)
    private String remark;

    /** 成果类型名 */
    @ApiModelProperty(value = "成果类型名", position = 7)
    private String resultName;
}