package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 查询审核表VO
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询审核表VO")
public class ComProjectAuditQueryVO extends PaginationVO{
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 1 )
    private Integer reportYear;
    /** 审核类型 */
    @ApiModelProperty(value = "审核类型", position = 2 )
    private Integer auditType;
    /** 审核对象Id */
    @ApiModelProperty(value = "审核对象Id", position = 3 )
    @Length(max=36, message = "审核对象Id不能大于36")
    private String auditObjectId;
    /** 审核方式  1 项目审核  5 项目终审 */
    @ApiModelProperty(value = "审核类型", position = 2 )
    private Integer auditMethod;
    /** 审核单位Id */
    @ApiModelProperty(value = "审核单位Id", position = 4 )
    @Length(max=36, message = "审核单位Id不能大于36")
    private String auditUnitId;
    /** 审核内容 */
    @ApiModelProperty(value = "审核内容", position = 5 )
    @Length(max=2000, message = "审核内容不能大于2000")
    private String auditContent;
    /** 审核结果 */
    @ApiModelProperty(value = "审核结果", position = 6 )
    private Integer auditResult;
    /** 审核时间 */
    @ApiModelProperty(value = "审核时间", position = 7 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date auditDate;
    /** 审核序号 */
    @ApiModelProperty(value = "审核序号", position = 8 )
    private Integer showIndex;
    /** 审核单位级别 */
    @ApiModelProperty(value = "审核单位级别", position = 9 )
    private Integer unitLevel;
    /** 审核人 */
    @ApiModelProperty(value = "审核人", position = 10 )
    @Length(max=36, message = "审核人不能大于36")
    private String comPerson;

    /** 项目名称 */
    @ApiModelProperty(value = "审核人", position = 41)
    private String auditPersonName;

    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1)
    private String projName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2)
    private String projNo;
    /** 申请编号 */
    @ApiModelProperty(value = "申请编号", position = 2)
    private String appNo;
    /** 项目类别 */
    @ApiModelProperty(value = "项目类别", position = 3)
    private String projClass;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 41)
    private String profession;
    /** 项目类型  1 科研项目  2重点学科项目 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private Integer systemType;
    /** 二级学科Id */
    @ApiModelProperty(value = "二级学科Id", position = 4)
    private String knowledgeParentId;
    /** 学科Id */
    @ApiModelProperty(value = "学科Id", position = 16 )
    @Length(max=36, message = "学科Id不能大于36")
    private String knowledgeId;
    /** 学科Id */
    private String knowledgeCode;
    /** 项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项 */
    @ApiModelProperty(value = "项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项", position = 7)
    private Integer projState;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 10)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 11)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /** 树编码 */
    @ApiModelProperty(value = "树编码", position = 1)
    private String treeCode;
    /** 单位名称id */
    @ApiModelProperty(value = "单位名称id", position = 41)
    private String appUnitId;
    /** 单位名称 */
    @ApiModelProperty(value = "单位名称", position = 41)
    private String appUnitName;
    /** 申报人身份证号 */
    @ApiModelProperty(value = "申报人身份证号", position = 41)
    private String certId;
    /** 申报人id */
    @ApiModelProperty(value = "申报人id", position = 41)
    private String appPersonId;
    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 41)
    private String appPersonName;
    /** 考核年度 */
    @ApiModelProperty(value = "考核年度", position = 41)
    private Integer checkYear;
    /** 上报状态  1 未上报, 5 审核中,10 审核通过,20 审核不通过,30 返回修改 */
    @ApiModelProperty(value = "上报状态  1 未上报, 5 审核中,10 审核通过,20 审核不通过,30 返回修改", position = 9 )
    private Integer checkState;
    /** 任务书状态  0 未 填,-20 起 草, -10 待提交,1 审核中,10 审核通过,20 审核不通过,30 返回修改 */
    @ApiModelProperty(value = "任务书状态  0 未 填,-20 起 草, -10 待提交,1 审核中,10 审核通过,20 审核不通过,30 返回修改", position = 3 )
    private Integer testState;
    /** 分配状态 0未分配 1已分配 */
    @ApiModelProperty(value = "分配状态", position = 6 )
    private Integer assignState;
    /** 是否评审完成 0否 1是 */
    @ApiModelProperty(value = "是否评审完成", position = 6 )
    private Integer completed;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 4)
    private BigDecimal totalScore;
    /** 平均分 */
    @ApiModelProperty(value = "平均分", position = 4)
    private BigDecimal averageScore;
    /** 评分 */
    @ApiModelProperty(value = "评分", position = 4)
    private String gradeScore;
    /** 开始 */
    @ApiModelProperty(value = "开始", position = 4)
    private BigDecimal scoreStart;
    /** 结束 */
    @ApiModelProperty(value = "结束", position = 4)
    private BigDecimal scoreEnd;
    /** 项目组Id */
    @ApiModelProperty(value = "项目组Id", position = 4)
    @Length(max=36, message = "项目组Id不能大于36")
    private String groupId;
    /** 人才类别 */
    @ApiModelProperty(value = "人才类别", position = 41)
    private String talentCategory;
}
