package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 查询审核表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询审核表VO")
public class ComProjectAuditNoteQueryVO extends PaginationVO{
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 1)
    private Integer reportYear;
    /** 审核类型 */
    @ApiModelProperty(value = "审核类型", position = 2)
    private Integer auditType;
    /** 审核对象Id */
    @ApiModelProperty(value = "审核对象Id", position = 3)
    private String auditObjectId;
    /** 审核方式  1 项目审核  5 项目终审 */
    @ApiModelProperty(value = "审核类型", position = 2 )
    private Integer auditMethod;
    /** 审核单位Id */
    @ApiModelProperty(value = "审核单位Id", position = 4)
    private String auditUnitId;
    /** 1 待审核，10 审核通过， 20 审核不通过 ，30 返回修改 */
    @ApiModelProperty(value = "1 待审核，10 审核通过， 20 审核不通过 ，30 返回修改", position = 5)
    private String auditContent;
    /** 审核结果 1 待审核，10 审核通过， 20 审核不通过 ，30 返回修改*/
    @ApiModelProperty(value = "审核结果", position = 6)
    private Integer auditResult;
    /** 审核时间 */
    @ApiModelProperty(value = "审核时间", position = 7)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date auditDate;
    /** 审核序号 */
    @ApiModelProperty(value = "审核序号", position = 8)
    private Integer showIndex;
    /** 审核单位级别 */
    @ApiModelProperty(value = "审核单位级别", position = 9)
    private Integer unitLevel;
    /** 审核人 */
    @ApiModelProperty(value = "审核人", position = 10)
    private String comPerson;
}