package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 查询附件表VO
 * 
 * @author lkl
 * @version 2021-08-25
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询附件表VO")
public class ComDownloadQueryVO extends PaginationVO {
    /** 申请编号 */
    @ApiModelProperty(value = "申请编号", position = 4)
    private String appNo;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2)
    private String projNo;
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1)
    private String projName;
    /** 申报年度 */
    @ApiModelProperty(value = "申报年度", position = 6)
    private Integer reportYear;
    /** 项目状态 */
    @ApiModelProperty(value = "项目状态", position = 6)
    private Integer ProjState;
    /** URL */
    @ApiModelProperty(value = "URL", position = 1)
    private String downloadUrl;
    /** URL */
    @ApiModelProperty(value = "转换文件URL", position = 2)
    private String convertUrl;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 3)
    private String fileName;
    /** 后缀 */
    @ApiModelProperty(value = "后缀", position = 4)
    private String extension;
}