package com.yiboshi.science.param.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper= false)
@ApiModel(description = "DTO")
public class UserImportDTO implements Serializable {
    /** 单位编码 */
    @ExcelProperty("单位编码")
    @ApiModelProperty(value = "单位编码", position = 22)
    private String unitCode;

    /** 单位 */
    @ExcelProperty("单位")
    @ApiModelProperty(value = "单位", position = 20)
    private String unitName;

    /** 用户名 */
    @ExcelProperty("用户名")
    @ApiModelProperty(value = "用户名", position = 22)
    private String username;

    /** 密码 */
    @ExcelProperty("密码")
    @ApiModelProperty(value = "密码", position = 22)
    private String password;

    /** 角色Id */
    @ExcelProperty("角色Id")
    private String roles;

    /** 人员编码 */
    @ExcelProperty("人员编码")
    @ApiModelProperty(value = "人员编码", position = 22)
    private String personCode;

    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 6)
    private String personName;

    /** 证件号 */
    @ExcelProperty("证件号")
    @ApiModelProperty(value = "证件号", position = 5)
    @Length(max=18, message = "证件号不能大于18")
    private String certId;


    /** 出生日期 */
    @ExcelProperty("出生日期")
    @ApiModelProperty(value = "出生日期", position = 8)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;

    /** 性别 */
    @ExcelProperty("性别")
    @ApiModelProperty(value = "性别", position = 7)
    private String sex;

    /** 电话号码 */
    @ExcelProperty("电话号码")
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;

    /** 邮箱 */
    @ExcelProperty("邮箱")
    @ApiModelProperty(value = "邮箱", position = 15)
    private String email;

    /** 专业 */
    @ExcelProperty("专业")
    @ApiModelProperty(value = "专业", position = 12)
    private String specName;

    /** 职称 */
    @ExcelProperty("职称")
    @ApiModelProperty(value = "职称", position = 10)
    private String titleName;

    /** 状态  1 启用  2 停用 */
    @ExcelProperty("状态")
    @ApiModelProperty(value = "状态  1 启用  2 停用", position = 3 )
    private Integer state;

    /** 导入状态 */
    @ExcelProperty("导入状态")
    @ApiModelProperty(value = "导入状态", position = 22)
    private String importState;

    /** 备注 */
    @ExcelProperty("备注")
    private String remark;
}
