package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 登录日志表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "登录日志表DTO")
public class LogsLoginDTO extends BaseDTO {
    /** 用户名 */
    @ApiModelProperty(value = "用户名" )
    private String username;
    /** 用户Id */
    @ApiModelProperty(value = "用户Id", position = 4)
    private String personId;
    /** 登录名 */
    @ApiModelProperty(value = "登录名" )
    private String loginName;
    /** 登录单位 */
    @ApiModelProperty(value = "登录单位" )
    private String loginUnit;
    /** 角色*/
    @ApiModelProperty(value = "角色", position = 7 )
    private String roles;
    /** 登录ip */
    @ApiModelProperty(value = "登录ip", position = 3)
    private String loginIp;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 4)
    @Length(max=200, message = "备注长度不能大于200")
    private String remark;
}