package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目分组明细表DTO")
public class ComProjectGroupDetailDTO extends BaseDTO {
    /** 项目组Id */
    @ApiModelProperty(value = "项目组Id", position = 1)
    @Length(max=36, message = "项目组Id不能大于36")
    private String groupId;

    /** 二级学科Id */
    @ApiModelProperty(value = "二级学科Id", position = 1)
    @Length(max=36, message = "二级学科Id不能大于36")
    private String knowledgeId;

    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 2)
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 3)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;

    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 4)
    @Length(max=100, message = "项目编号不能大于100")
    private String projNo;

    /** 申请编号 */
    @ApiModelProperty(value = "申请编号", position = 2 )
    private String appNo;

    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 5)
    @Length(max=150, message = "项目名称不能大于150")
    private String projName;

    /** 项目类别  1 一般项目  2重点项目 */
    @ApiModelProperty(value = "项目类别", position = 1 )
    private Integer projClass;

    /** 学科 */
    @ApiModelProperty(value = "学科", position = 6)
    private String knowledgeName;

    /** 申报人Id */
    @ApiModelProperty(value = "项目名称", position = 5)
    private String appPersonId;

    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 4)
    private String personName;

    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 2)
    private String certId;

    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id", position = 6)
    private String appUnitId;

    /** 申报单位名称 */
    @ApiModelProperty(value = "申报单位名称", position = 7)
    private String appUnitName;

    private String key;
    private String title;
    private String description;

    private String pkey;
    private String ppkey;
}

