package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 申报人科研学术成绩表DTO
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "申报人科研学术成绩表DTO")
public class ComPersonScientificGainDTO extends BaseDTO {
    
    @ApiModelProperty(value = "主键")
    private String id;

    /** 人才申请Id */
    @ApiModelProperty(value = "人才申请Id")
    private String talentId;

    @ApiModelProperty(value = "成果类型")
    private String gainType;

    @ApiModelProperty(value = "成果类型名称")
    private String gainTypeName;
    
    @ApiModelProperty(value = "成果日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date gainDate;
    
    @ApiModelProperty(value = "成果名称")
    private String gainName;
    
    @ApiModelProperty(value = "成果描述")
    private String gainDescription;
    
    @ApiModelProperty(value = "成果备注")
    private String gainRemark;

    @ApiModelProperty(value = "排序")
    private Integer showIndex;
} 