package com.yiboshi.science.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 申报人培养经费预算表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("com_talent_budget")
@ApiModel(description = "申报人培养经费预算表VO")
public class ComTalentBudget extends BaseEntity {
    
    /** 人才申请ID */
    @ApiModelProperty(value = "人才申请ID", position = 1)
    @Length(max=36, message = "人才申请ID不能大于36")
    private String talentId;
    
    /** 预算科目ID */
    @ApiModelProperty(value = "预算科目ID", position = 2)
    @Length(max=36, message = "预算科目ID不能大于36")
    private String budgetId;
    
    /** 第一年预算 */
    @ApiModelProperty(value = "第一年预算", position = 3)
    private BigDecimal yearValue1;
    
    /** 第二年预算 */
    @ApiModelProperty(value = "第二年预算", position = 4)
    private BigDecimal yearValue2;
    
    /** 第三年预算 */
    @ApiModelProperty(value = "第三年预算", position = 5)
    private BigDecimal yearValue3;
    
    /** 第四年预算 */
    @ApiModelProperty(value = "第四年预算", position = 6)
    private BigDecimal yearValue4;
    
    /** 第五年预算 */
    @ApiModelProperty(value = "第五年预算", position = 7)
    private BigDecimal yearValue5;

    /** 合计 */
    @ApiModelProperty(value = "合计", position = 7)
    private BigDecimal amountFee;
    
    /** 预算科目名称 */
    @ApiModelProperty(value = "预算科目名称", position = 8)
    @Length(max=100, message = "预算科目名称不能大于100")
    private String budgetName;

    /** 排序 */
    @ApiModelProperty(value = "排序", position = 9)
    private Integer showIndex;

    /** 是否为必填项 */
    @ApiModelProperty(value = "是否为必填项", position = 10)
    private Boolean isRequired;
} 