package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 经费申请表（任务书/项目申请书）VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "经费申请表（任务书/项目申请书）VO")
public class ComProjectBudget extends BaseEntity {

    /** 经费类别Id (参数表获取) */
    @ApiModelProperty(value = "经费类别Id (参数表获取)", position = 1)
    @Length(max=36, message = "经费类别Id (参数表获取)不能大于36")
    private String budgetId;
    /** 对象id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象id（项目Id/任务书Id）", position = 2)
    @Length(max=36, message = "对象id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 总预算数 */
    @ApiModelProperty(value = "总预算数", position = 3)
    private BigDecimal totalBudget;
    /** 申请专项经费(临床科技项目) */
    @ApiModelProperty(value = "申请专项经费", position = 4)
    private BigDecimal applyFunds;
    /** 自筹经费(临床科技项目) */
    @ApiModelProperty(value = "自筹经费", position = 5)
    private BigDecimal selfFunds;
    /** 计算依据/备注 */
    @ApiModelProperty(value = "计算依据/备注", position = 6)
    private String calculationBasis;
}