package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComPerson;
import com.yiboshi.science.param.dto.ComPersonDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComPersonQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人员表 DAO
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComPersonDAO extends BaseMapper<ComPerson>, BaseDAO<ComPersonQueryVO,ComPersonDTO,ComPerson> {
    ComPersonDTO getPersonById(String id);
    List<ComPersonDTO> getList();
    List<ComPersonDTO> getManagerListByUnitId(String unitId);
    Page<ComPersonDTO> getAllListByPage(Page<ComPersonQueryVO> page, @Param("ew") Wrapper<ComPersonQueryVO> queryWrapper);
    DataStatisticsDTO getRegisterPersonCount(@Param("ew") Wrapper<ComPersonQueryVO> queryWrapper);
    DataStatisticsDTO getRegisterPersonCountByDay(@Param("ew") Wrapper<ComPersonQueryVO> queryWrapper);
}
