/*
 * Copyright 2019-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.yiboshi.science.config.verification;


import lombok.Data;

/**
 * 登录验证码配置信息
 *
 * @author Anker
 * @date: 2020/6/10 18:53
 */
@Data
public class VerificationCode {

    /**
     * 验证码配置
     */
    private VerificationCodeEnum codeType;
    /**
     * 验证码有效期 分钟
     */
    private Long expiration = 1L;
    /**
     * 验证码内容长度
     */
    private int length = 2;
    /**
     * 验证码宽度
     */
    private int width = 111;
    /**
     * 验证码高度
     */
    private int height = 36;
    /**
     * 验证码字体
     */
    private String fontName;
    /**
     * 字体大小
     */
    private int fontSize = 25;

    public VerificationCodeEnum getCodeType() {
        return codeType;
    }
}
