package com.yiboshi.science.config.security;

import com.alibaba.fastjson.JSONObject;
import com.yiboshi.arch.base.ResponseCode;
import com.yiboshi.arch.base.ResponseDataModel;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component
public class AuthorizationAccessDeniedHandler implements AccessDeniedHandler {

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        response.setStatus(HttpStatus.OK.value());
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        try {
            response.getWriter().write(JSONObject.toJSONString(new ResponseDataModel(ResponseCode.SERVER_ERROR.code(),"权限认证失败","")));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}