package com.yiboshi.science.config.bean;

import com.yiboshi.science.config.verification.VerificationCodeProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigBeanConfiguration {

    @Bean
    @ConfigurationProperties(prefix = "system", ignoreUnknownFields = true)
    public SystemProperties systemProperties() { return new SystemProperties();}

    @Bean
    @ConfigurationProperties(prefix = "verification", ignoreUnknownFields = true)
    public VerificationCodeProperties verificationCodeProperties() { return new VerificationCodeProperties();}
}
