package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComTalentBudgetDAO;
import com.yiboshi.science.entity.ComTalentBudget;
import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.param.dto.ComTalentBudgetDTO;
import com.yiboshi.science.param.query.ComTalentBudgetQueryVO;
import com.yiboshi.science.service.ComTalentBudgetService;
import com.yiboshi.science.service.SystemParameterService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 申报人培养经费预算表 Service 实现类
 * @author xujun
 * @version 2025-03-12
 */

@Service
@AllArgsConstructor
public class ComTalentBudgetServiceImpl extends BaseServiceImpl<ComTalentBudgetDAO, ComTalentBudgetQueryVO, ComTalentBudgetDTO, ComTalentBudget> implements ComTalentBudgetService {

    @Autowired
    private ComTalentBudgetDAO comTalentBudgetDAO;

    @Autowired
    private SystemParameterService systemParameterService;

    @Override
    protected void setCriteriaForQuery(ComTalentBudgetQueryVO vo, QueryWrapper<ComTalentBudgetQueryVO> criteria) {

    }

    public void insertList(List<ComTalentBudgetDTO> list, String TalentId) {
        ComTalentBudget budget = new ComTalentBudget();
        budget.setTalentId(TalentId);
        this.delete(budget);
        if (null != list) {
            List<ComTalentBudget> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComTalentBudget item = convert2Entity(list.get(i));
                item.setTalentId(TalentId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }

    public List<ComTalentBudgetDTO> getListByTalentId(String talentId) {
        return comTalentBudgetDAO.getListByTalentId(talentId);
    }

    public List<ComTalentBudgetDTO> getList() {
        List<ComTalentBudgetDTO> budgetList = new ArrayList<>();
        List<SystemParameter> list = systemParameterService.getListByType(20);
        int i = 1;

        for (SystemParameter p : list) {
            ComTalentBudgetDTO newVO = new ComTalentBudgetDTO();
            newVO.setBudgetId(p.getId());
            newVO.setYearValue1(new BigDecimal(0.00));
            newVO.setYearValue2(new BigDecimal(0.00));
            newVO.setYearValue3(new BigDecimal(0.00));
            newVO.setYearValue4(new BigDecimal(0.00));
            newVO.setYearValue5(new BigDecimal(0.00));
            newVO.setAmountFee(new BigDecimal(0.00));
            newVO.setBudgetName(p.getName());
            newVO.setShowIndex(i);
            newVO.setIsRequired(p.getIsRequired());
            budgetList.add(newVO);
            i++;
        }

        return budgetList;
    }

    /** 删除对象列表
     *
     * @param objectId
     */
    public void deleteByObjectId(String objectId) {
        ComTalentBudget e = new ComTalentBudget();
        e.setTalentId(objectId);
        this.delete(e);
    }
}
