package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.SystemRole;
import com.yiboshi.science.param.dto.SystemRoleDTO;
import com.yiboshi.science.param.query.SystemRoleQueryVO;

import java.util.List;

/**
 * 系统角色表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface SystemRoleService extends BaseService<SystemRoleQueryVO, SystemRoleDTO, SystemRole> {
    /**
     * 根据 id获取角色
     * @param id
     * @return
     */
    SystemRoleDTO getRoleById(String id);
    /**
     * 更新角色
     * @param entity
     * @return
     */
    String updateRole(SystemRole entity);
    /**
     * 新增角色
     * @param entity
     * @return
     */
    String insertRole(SystemRole entity);
    /**
     * 根据 角色列表
     * @param
     * @return
     */
    List<SystemRole> getRoleList();
    /**
     * 根据 根据角色获取权限
     * @param roleId
     * @return
     */
    String getAuthorityByRoleId(String roleId);
}
