package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComUnit;
import com.yiboshi.science.param.dto.ComUnitDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComUnitQueryVO;

import java.util.List;

/**
 * 单位表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComUnitService extends BaseService<ComUnitQueryVO, ComUnitDTO, ComUnit> {

    /** 获取最高级单位
     *
     * @return
     */
    ComUnitDTO getTopUnit();
    /** 根据单位编码获取单位信息
     *
     * @param treeCode 单位编码
     * @return
     */
    ComUnitDTO getByTreeCode(String treeCode);

    /** 获取上级单位信息
     *
     * @param id
     * @return
     */
    ComUnitDTO getUpUnitById(String id);

    /**获取单位信息
     *
     * @param id
     * @return
     */
    ComUnitDTO getUnitById(String id);

    /**获取单位信息
     *
     * @param id
     * @return
     */
    ComUnit getUnitInfoByLongId(Long id);

    /**根据单位编码获取下级单位
     *
     * @param treeCode
     * @return
     */
    List<ComUnitDTO> getListByTreeCode(String treeCode);

    /**获取单位列表
     *
     * @param unitType
     * @return
     */
    List<ComUnitDTO> getListByType(Integer unitType);

    /**
     * 根据单位名称获取单位列表
     * @param UnitName
     * @return
     */
    List<ComUnitDTO> getListByUnitName(String UnitName);


    /**
     * 单位注册
     * @param unit
     * @return
     */
    String register(ComUnitDTO unit);

    /**
     * 单位审核
     * @param unit
     * @return
     */
    String audit(ComUnitDTO unit);

    /**
     * 保存/修改单位
     * @param dto
     * @return
     */
    String save(ComUnitDTO dto);

    /**删除单位
     *
     * @param Id
     */
    String deleteUnit(String Id);


    /**
     * 保存/修改单位
     * @param unit
     * @return
     */
    String updateUnitState(ComUnitDTO unit);



    /**
     * 判断单位是否存在
     * @param unitName
     * @return
     */
     ComUnit isExist(String unitName);

    /**
     * 获取数编码
     * @param fatherCode
     * @return
     */
    String getNewCode(String fatherCode);

    DataStatisticsDTO getRegisterUnitCount(ComUnitQueryVO v);

    DataStatisticsDTO getRegisterUnitCountByDay(ComUnitQueryVO v);

    boolean isComplete(ComUnit comUnit);
}
