package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectAudit;
import com.yiboshi.science.entity.ComTalentApply;
import com.yiboshi.science.param.dto.ComProjectAuditDTO;
import com.yiboshi.science.param.dto.ComTalentApplyDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComTalentApplyQueryVO;

/**
 * 人才申请表
 */
public interface ComTalentApplyService extends BaseService<ComTalentApplyQueryVO, ComTalentApplyDTO, ComTalentApply> {

    /**
     * 获取统计数据
     * @return
     */
    DataStatisticsDTO getCount(ComTalentApply e);

    String save(ComTalentApplyDTO dto);

    ComTalentApplyDTO getNewTalentApply();

    ComTalentApplyDTO getTalentApplyById(String id);

    Boolean isTalentExist();

    /**
     * 删除人才申报信息
     *
     * @return
     */
    String delete(String id);

    void report(ComProjectAudit model, String unitId, String treeCode);

    /**
     * 人才申报信息审核
     *
     * @param e
     * @return
     */
    void audit(ComProjectAuditDTO e, String auditUnitId, String auditTreeCode);

    /**
     * 人才申报信息审核(批量)
     * @param dto
     * @param auditUnitId
     * @param auditTreeCode
     */
    void batchAudit(ComProjectAuditDTO dto, String auditUnitId, String auditTreeCode);

}
