package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectUnitPayment;
import com.yiboshi.science.param.dto.ComProjectUnitPaymentDTO;
import com.yiboshi.science.param.query.ComProjectUnitPaymentQueryVO;

import java.util.List;

/**
 * 单位研究资金支出预算明细表 Service
 *
 * @author xujun
 * @version 2024-11-28
 */
public interface ComProjectUnitPaymentService extends BaseService<ComProjectUnitPaymentQueryVO, ComProjectUnitPaymentDTO, ComProjectUnitPayment> {
    /** 根据对象获取合作单位列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectUnitPaymentDTO> getListByObjectId(String objectId);

    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
    /** 插入合作单位
     *
     * @param togetherList
     * @param objectId
     */
    void insertList(List<ComProjectUnitPaymentDTO> togetherList, String objectId);
}
