package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectAudit;
import com.yiboshi.science.entity.ComProjectTask;
import com.yiboshi.science.param.dto.ComProjectTaskDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComProjectTaskQueryVO;

/**
 * 任务书表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectTaskService extends BaseService<ComProjectTaskQueryVO, ComProjectTaskDTO,ComProjectTask> {
    /**
     * 获取统计数据
     *
     * @return
     */
    DataStatisticsDTO getCount(ComProjectTaskQueryVO e);
    /** 根据id更新状态
     *
     * @param id
     * @param state
     */
    void updateState(String id,Integer state);
    /** 根据id获取任务书信息
     *
     * @param id
     * @return
     */
    ComProjectTaskDTO getTaskByProjId(String id);
    /**
     * 保存任务书信息
     *
     * @param ComProjectTaskDTO
     * @return
     */
    String save(ComProjectTaskDTO ComProjectTaskDTO);
    /** 项目/任务书/中期考核上报
     *
     * @param comProjectAudit
     * @param unitId
     * @param treeCode
     * @return
     */
    void report(ComProjectAudit comProjectAudit, String unitId, String treeCode);
    /** 项目/任务书/中期考核审核
     *
     * @param comProjectAudit
     * @param unitId
     * @param treeCode
     * @return
     */
    void audit(ComProjectAudit comProjectAudit, String unitId, String treeCode);

}
