package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectBudget;
import com.yiboshi.science.param.dto.ComProjectBudgetDTO;
import com.yiboshi.science.param.query.ComProjectBudgetQueryVO;

import java.util.List;

/**
 * 经费申请表（任务书/项目申请书） Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectBudgetService extends BaseService<ComProjectBudgetQueryVO, ComProjectBudgetDTO,ComProjectBudget> {
    /** 获取经费列表（空对象）
     *
     * @return
     */
    List<ComProjectBudgetDTO> getList();

//    /**
//     * 初始化控件值
//     * @param budgetList
//     * @return
//     */
//    List<ComProjectBudgetDTO> budgetControlInit(List<ComProjectBudgetDTO> budgetList);

    /** 根据对象获取经费列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectBudgetDTO> getListByObjectId(String objectId);

    /**插入经费表
     *
     * @param budgetList
     * @param objectId
     */
    void insertBudgetList(List<ComProjectBudgetDTO> budgetList, String objectId);

    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
}
