package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComProjectGroupDetail;
import com.yiboshi.science.param.dto.ComProjectGroupDetailDTO;
import com.yiboshi.science.param.query.ComProjectGroupDetailQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComProjectGroupDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@Api(tags = "com-project-group-detail", description = "项目组明细表")
@RestController
@RequestMapping("/v1/science-admin/com-project-group-detail")
public class ComProjectGroupDetailController extends BaseController<ComProjectGroupDetailService, ComProjectGroupDetailQueryVO, ComProjectGroupDetailDTO, ComProjectGroupDetail> {

    @Autowired
    private ComProjectGroupDetailService comProjectGroupDetailService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getProjectDetailListbyPage")
    public ResponseDataModel<Pagination<ComProjectGroupDetailDTO>> getProjectDetailListbyPage(@Validated ComProjectGroupDetailQueryVO vo, BindingResult bindingResult) {
        Pagination<ComProjectGroupDetailDTO> page = comProjectGroupDetailService.getProjectDetailListbyPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "根据类型参数列表", httpMethod = "GET", notes = "根据类型参数列表")
    @GetMapping
    @RequestMapping("/getProjectListByGroupIds")
    public ResponseDataModel<List<ComProjectGroupDetailDTO>> getProjectListByGroupIds(@RequestParam String groupIds) {
        String[] split = groupIds.split(",");
        List<String> GroupList = Arrays.asList(split);
        List<ComProjectGroupDetailDTO> list = comProjectGroupDetailService.getProjectListByGroupIds(GroupList);
        list.forEach(e -> {
            e.setKey(e.getId());
            e.setTitle(e.getProjNo());
            e.setDescription(e.getProjName());
        });
        return ResponseDataModel.ok(list);
    }
}
