package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 人才团队成员表查询VO
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "人才团队成员表查询VO")
public class ComTalentMembersQueryVO extends PaginationVO {

    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "人才申请ID")
    private String talentId;

    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "性别")
    private String sex;

    @ApiModelProperty(value = "出生日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    private Date birthday;

    @ApiModelProperty(value = "专业")
    private String spec;

    @ApiModelProperty(value = "职务")
    private String title;

    @ApiModelProperty(value = "工作单位")
    private String workUnit;

    @ApiModelProperty(value = "项目分工")
    private String projWork;

    @ApiModelProperty(value = "备注")
    private String remark;
} 