package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 申报人科研学术成绩表查询VO
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "申报人科研学术成绩表查询VO")
public class ComPersonScientificGainQueryVO extends PaginationVO {

    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "人才申请Id")
    private String talentId;

    @ApiModelProperty(value = "成果类型")
    private String gainType;

    @ApiModelProperty(value = "成果日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date gainDate;

    @ApiModelProperty(value = "成果名称")
    private String gainName;

    @ApiModelProperty(value = "成果描述")
    private String gainDescription;

    @ApiModelProperty(value = "成果备注")
    private String gainRemark;
} 