package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 中期考核表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "中期考核表VO")
public class ComProjectCheck extends BaseEntity {

    /** 考核年度 */
    @ApiModelProperty(value = "考核年度", position = 1 )
    private Integer checkYear;
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 2 )
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 阶段性成果其他 */
    @ApiModelProperty(value = "阶段性成果其他", position = 3 )
    @Length(max=800, message = "阶段性成果其他不能大于800")
    private String otherResults;
    /** 研究工作进展 */
    @ApiModelProperty(value = "研究工作进展", position = 4 )
    @Length(max=800, message = "研究工作进展不能大于800")
    private String workProgress;
    /** 项目批准经费 */
    @ApiModelProperty(value = "项目批准经费", position = 5 )
    private BigDecimal applyMoney;
    /** 已使用经费 */
    @ApiModelProperty(value = "已使用经费", position = 6 )
    private BigDecimal usingMoney;
    /** 现结余经费 */
    @ApiModelProperty(value = "现结余经费", position = 7 )
    private BigDecimal surplusMoney;
    /** 经费具体使用情况说明 */
    @ApiModelProperty(value = "经费具体使用情况说明", position = 8 )
    @Length(max=800, message = "经费具体使用情况说明不能大于800")
    private String moneyInstructions;
    /** 上报状态  1 未上报, 5 审核中,10 审核通过,20 审核不通过,30 返回修改 */
    @ApiModelProperty(value = "上报状态  1 未上报, 5 审核中,10 审核通过,20 审核不通过,30 返回修改", position = 9 )
    private Integer checkState;

}