package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComTalentGroupDetail;
import com.yiboshi.science.param.dto.ComTalentGroupDetailDTO;
import com.yiboshi.science.param.query.ComTalentGroupDetailQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人才分组明细表
 */
public interface ComTalentGroupDetailDAO extends BaseMapper<ComTalentGroupDetail>, BaseDAO<ComTalentGroupDetailQueryVO, ComTalentGroupDetailDTO, ComTalentGroupDetail> {

    ComTalentGroupDetailDTO getTalentGroupDetailByGP(@Param("groupId") String groupId, @Param("talentId") String talentId);

    List<ComTalentGroupDetailDTO> getTalentDetailList(String groupId);

    List<ComTalentGroupDetailDTO> getTalentDetailList2(String groupId);

    Page<ComTalentGroupDetailDTO> getTalentDetailListbyPage(Page<ComTalentGroupDetailQueryVO> page, @Param("ew") Wrapper<ComTalentGroupDetailQueryVO> queryWrapper);

    List<ComTalentGroupDetailDTO> getTalentListByGroupIds(@Param("groupIds") List<String> groupList);
    List<ComTalentGroupDetailDTO> getMembersListByGroupIds(@Param("groupIds") List<String> groupList);
}
