package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComProjectGroup;
import com.yiboshi.science.param.dto.ComProjectAssignDTO;
import com.yiboshi.science.param.dto.ComProjectGroupDTO;
import com.yiboshi.science.param.dto.ComProjectKnowledgeStatisticDTO;
import com.yiboshi.science.param.query.ComProjectGroupQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface ComProjectGroupDAO extends BaseMapper<ComProjectGroup>, BaseDAO<ComProjectGroupQueryVO, ComProjectGroupDTO, ComProjectGroup> {

    ComProjectGroupDTO getProjectGroupByKnowLedgeIDYear(@Param("groupYear") Integer name, @Param("knowledgeId") String knowledgeId);

    List<ComProjectAssignDTO> getAssignExpertList(String projectId);

    List<ComProjectKnowledgeStatisticDTO> getProjectKnowledgeStatisticByGroupId(String groupId);
}
