/* Copyright (c) 2018, yiboshi.com All Rights Reserved. */
package com.yiboshi.science.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yiboshi.science.Constants;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * VO基类
 * @author NEGI
 * @version 2018-10
 */
public abstract class BaseVO {
    @ApiModelProperty(value="主键id",hidden = true)
//    @NotNull(groups = {ValidatorGroup.Update.class})
    private String id;

    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private String operId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOperId() {
        return operId;
    }

    public void setOperId(String operId) {
        this.operId = operId;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toStringExclude(this, Constants.excludeFieldNames);
    }
}
