package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.SystemRoleDAO;
import com.yiboshi.science.entity.SystemRole;
import com.yiboshi.science.param.dto.SystemRoleDTO;
import com.yiboshi.science.param.query.SystemRoleQueryVO;
import com.yiboshi.science.service.SystemRoleService;
import com.yiboshi.science.utils.RedisKey;
import com.yiboshi.science.utils.RedisUtils;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * 系统角色表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
@AllArgsConstructor
public class SystemRoleServiceImpl extends BaseServiceImpl<SystemRoleDAO, SystemRoleQueryVO, SystemRoleDTO, SystemRole> implements SystemRoleService {
    @Autowired
    private SystemRoleDAO systemRoleDAO;

    private final RedisUtils redisUtils;

    @Override
    protected void setCriteriaForQuery(SystemRoleQueryVO vo, QueryWrapper<SystemRoleQueryVO> criteria) {
        if (Objects.nonNull(vo.getName())) {
            criteria.eq("name", vo.getName());
        }
    }

    @Override
    public Pagination<SystemRoleDTO> getListByPage(SystemRoleQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<SystemRoleQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<SystemRoleDTO> dtoList = systemRoleDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    public SystemRoleDTO getRoleById(String id) {
        return this.dtoById(id);
    }

    public String updateRole(SystemRole entity) {
        this.update(entity);
        return this.update(entity);
    }

    public String insertRole(SystemRole entity) {
        Integer roleId = getMaxRoleId();
        entity.setRoleId(roleId == null ? 1 : roleId + 1);
        this.insert(entity);
        return this.insert(entity);
    }

    public Integer getMaxRoleId() {
        return systemRoleDAO.getMaxRoleId();
    }

    public List<SystemRole> getRoleList() {
        return this.entityAll();
    }

    public String getAuthorityByRoleId(String roleId) {
        String authority = "";
        String[] arr = roleId.split(",");
        for (int i = 0; i < arr.length; i++) {
            for (SystemRole role : this.entityAll()) {
                if (role.getRoleId().toString().equals(arr[i])) {
                    authority += "," + role.getAuthority();
                    break;
                }
            }
        }
        if (!authority.equals(""))
            authority = authority.substring(1);
        return authority;
    }

    /**
     * 获取所有参数
     *
     * @return
     */
    public List<SystemRole> getList() {
        List<SystemRole> list = null;
        Object obj = redisUtils.get(RedisKey.RoleList);
        if (null != obj)
            list = (List<SystemRole>) redisUtils.get(RedisKey.RoleList);
        else {
            list = this.entityAll();
            redisUtils.set(RedisKey.RoleList, list, 7, TimeUnit.DAYS);
        }
        return list;
    }

}
