package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.SystemMenuRoleDAO;
import com.yiboshi.science.entity.SystemMenu;
import com.yiboshi.science.entity.SystemMenuRole;
import com.yiboshi.science.param.dto.MenuTreeDTO;
import com.yiboshi.science.param.dto.SystemMenuRoleDTO;
import com.yiboshi.science.param.query.SystemMenuRoleQueryVO;
import com.yiboshi.science.service.SystemMenuRoleService;
import com.yiboshi.science.service.SystemMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 菜单权限表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class SystemMenuRoleServiceImpl extends BaseServiceImpl<SystemMenuRoleDAO, SystemMenuRoleQueryVO, SystemMenuRoleDTO, SystemMenuRole> implements SystemMenuRoleService {

    @Autowired
    private SystemMenuService systemMenuService;

    @Autowired
    private SystemMenuRoleDAO systemMenuRoleDAO;

    @Override
    protected void setCriteriaForQuery(SystemMenuRoleQueryVO vo, QueryWrapper<SystemMenuRoleQueryVO> criteria) {
        if (Objects.nonNull(vo.getRoleId())) {
            criteria.eq("role_id", vo.getRoleId());
        }
        if (Objects.nonNull(vo.getMenuId())) {
            criteria.eq("menu_id", vo.getMenuId());
        }
    }

    public List<SystemMenuRole> getMenuRoleByRoleId(int roleId) {
        SystemMenuRole menuRole = new SystemMenuRole();
        menuRole.setRoleId(roleId);
        List<SystemMenuRole> menuRoleList = this.entityList(menuRole);
        return menuRoleList.stream().filter(e -> e.getMenuId().toString().length() == 4).collect(Collectors.toList());
    }

    public String insertMenuRoleRecord(MenuTreeDTO menuTreeDTO) {
        if (!menuTreeDTO.isLeaf()) {
            this.deleteMenuRoleBatch(menuTreeDTO.getRoleId(), menuTreeDTO.getKey());
            List<SystemMenu> menuList = systemMenuService.getSystemMenuByParentId(menuTreeDTO.getKey());
            if (null != menuList) {
                List<SystemMenuRole> systemMenuRoleList = new ArrayList<>();
                menuList.forEach(e -> {
                    SystemMenuRole systemMenuRole = new SystemMenuRole();
                    systemMenuRole.setMenuId(e.getId());
                    systemMenuRole.setRoleId(menuTreeDTO.getRoleId());
                    systemMenuRoleList.add(systemMenuRole);
                });
                if (!isExitParentMenuById(menuTreeDTO.getRoleId(), menuTreeDTO.getKey())) {
                    SystemMenuRole systemMenuRole = new SystemMenuRole();
                    systemMenuRole.setMenuId(menuTreeDTO.getKey());
                    systemMenuRole.setRoleId(menuTreeDTO.getRoleId());
                    this.insertMenuRole(systemMenuRole);
                }
                return this.insertMenuRoleBatch(systemMenuRoleList);
            }
            return "角色菜单添加失败，请稍后再试！";
        } else {
            SystemMenu systemMenu = systemMenuService.getById(menuTreeDTO.getKey());
            if (null != systemMenu) {
                if (!isExitParentMenuById(menuTreeDTO.getRoleId(), systemMenu.getParentId())) {
                    SystemMenuRole systemMenuRole = new SystemMenuRole();
                    systemMenuRole.setMenuId(systemMenu.getParentId());
                    systemMenuRole.setRoleId(menuTreeDTO.getRoleId());
                    this.insertMenuRole(systemMenuRole);
                }
                SystemMenuRole systemMenuRole = new SystemMenuRole();
                systemMenuRole.setMenuId(menuTreeDTO.getKey());
                systemMenuRole.setRoleId(menuTreeDTO.getRoleId());
                return this.insertMenuRole(systemMenuRole);
            }
            return null;
        }
    }

    public String deleteMenuRoleRecord(MenuTreeDTO menuTreeDTO) {
        if (!menuTreeDTO.isLeaf()) {
            if (isExitParentMenuById(menuTreeDTO.getRoleId(), menuTreeDTO.getKey())) {
                SystemMenuRole systemMenuRole = new SystemMenuRole();
                systemMenuRole.setMenuId(menuTreeDTO.getKey());
                systemMenuRole.setRoleId(menuTreeDTO.getRoleId());
                this.delete(systemMenuRole);
            }
            return this.deleteMenuRoleBatch(menuTreeDTO.getRoleId(), menuTreeDTO.getKey());
        } else {
            SystemMenu systemMenu = systemMenuService.getById(menuTreeDTO.getKey());
            if (null != systemMenu) {
                List<SystemMenuRole> list = systemMenuRoleDAO.getMenuListById(menuTreeDTO.getRoleId(), systemMenu.getParentId(), menuTreeDTO.getKey());
                if (null == list || list.size() == 0) {
                    SystemMenuRole systemMenuRole = new SystemMenuRole();
                    systemMenuRole.setMenuId(systemMenu.getParentId());
                    systemMenuRole.setRoleId(menuTreeDTO.getRoleId());
                    this.delete(systemMenuRole);
                }
            }
            return this.deleteMenuRole(menuTreeDTO.getRoleId(), menuTreeDTO.getKey());
        }
    }

    public String insertMenuRole(SystemMenuRole systemMenuRole) {
        this.insert(systemMenuRole);
        return "角色菜单添加成功！";
    }

    public String insertMenuRoleBatch(List<SystemMenuRole> menuRoleList) {
        this.insertBatch(menuRoleList);
        return "角色菜单添加成功！";
    }

    public String deleteMenuRole(int roleId, String menuId) {
        systemMenuRoleDAO.deleteMenuRole(roleId, menuId);
        return "角色菜单删除成功！";
    }

    public String deleteMenuRoleBatch(int roleId, String parentId) {
        systemMenuRoleDAO.deleteMenuRoleBatch(roleId, parentId);
        return "角色菜单删除成功！";
    }

    public String updateMenuRole(List<SystemMenuRole> menuRoleList) {
        this.insertBatch(menuRoleList);
        return "角色菜单保存成功！";
    }

    public Boolean isExitParentMenuById(int RoleId, String ParentId) {
        SystemMenuRole systemMenuRole = new SystemMenuRole();
        systemMenuRole.setMenuId(ParentId);
        systemMenuRole.setRoleId(RoleId);
        systemMenuRole = this.getEntity(systemMenuRole);
        if (null != systemMenuRole)
            return true;
        else
            return false;
    }
}
