package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComTaskTargetDAO;
import com.yiboshi.science.entity.ComTaskTarget;
import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.param.dto.ComTaskTargetDTO;
import com.yiboshi.science.param.query.ComTaskTargetQueryVO;
import com.yiboshi.science.service.ComTaskTargetService;
import com.yiboshi.science.service.SystemParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 任务书预期成果表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComTaskTargetServiceImpl extends BaseServiceImpl<ComTaskTargetDAO, ComTaskTargetQueryVO, ComTaskTargetDTO,ComTaskTarget> implements ComTaskTargetService {


    @Autowired
    private ComTaskTargetDAO ComTaskTargetDAO;

    @Autowired
    private SystemParameterService systemParameterService;
    @Override
    protected void setCriteriaForQuery(ComTaskTargetQueryVO vo, QueryWrapper<ComTaskTargetQueryVO> criteria) {
        if(Objects.nonNull(vo.getTestId())){
            criteria.eq("test_id", vo.getTestId());
        }
        if(Objects.nonNull(vo.getTargetId())){
            criteria.eq("target_id", vo.getTargetId());
        }
        if(Objects.nonNull(vo.getResult())){
            criteria.eq("result", vo.getResult());
        }
        if(Objects.nonNull(vo.getResultCount())){
            criteria.eq("result_count", vo.getResultCount());
        }
    }
    @Override
    public List<ComTaskTargetDTO> getListByObjectId(String id)
    {
        return ComTaskTargetDAO.getListByObjectId(id);
    }
    @Override
    public void insertTestTargetList(List<ComTaskTargetDTO> testTargetList, String objectId) {
        ComTaskTarget E =new ComTaskTarget();
        E.setTestId(objectId);
        this.delete(E);
        if (null != testTargetList) {
            testTargetList.forEach(e -> e.setTestId(objectId));
            List<ComTaskTarget> list = convertDto2EntityList(testTargetList);
            this.insertBatch(list);
        }
    }
    @Override
    public List<ComTaskTargetDTO> getList() {
        List<SystemParameter> list = systemParameterService.getListByType(45);
        List<ComTaskTargetDTO> budgetList = new ArrayList<>();
        list.forEach((e) -> {
            ComTaskTargetDTO m = new ComTaskTargetDTO();
            m.setTargetId(e.getId());
            m.setTargetName(e.getName());
            m.setOrderNo(e.getDisplayOrder());
            m.setResultCount(0);
            m.setResult("False");
            m.setResultCount(0);
            budgetList.add(m);
        });
        return budgetList;
    }
}
